<?php

session_start();

require_once __DIR__ . '/Facebook/autoload.php'; // download official fb sdk for php @ https://github.com/facebook/php-graph-sdk

$fb = new Facebook\Facebook([
  'app_id' => '1111392495544954',
  'app_secret' => '33455f0102bdd7f58e4d6286e026d7aa',
  'default_graph_version' => 'v2.12',
  ]);

$helper = $fb->getRedirectLoginHelper();

$permissions = ['public_profile','user_birthday', 'user_location', 'email', 'user_likes'];

try {
  $accessToken = $helper->getAccessToken('https://iwifi.co.za/hotspots/happyoakbeta/step2.php', $permissions);
} catch(Facebook\Exceptions\FacebookResponseException $e) {
  // When Graph returns an error
  echo 'Graph returned an error: ' . $e->getMessage();
  exit;
} catch(Facebook\Exceptions\FacebookSDKException $e) {
  // When validation fails or other local issues
  echo 'Facebook SDK returned an error: ' . $e->getMessage();
  exit;
}

if (! isset($accessToken)) {
  if ($helper->getError()) {
    header('HTTP/1.0 401 Unauthorized');
    echo "Error: " . $helper->getError() . "\n";
    echo "Error Code: " . $helper->getErrorCode() . "\n";
    echo "Error Reason: " . $helper->getErrorReason() . "\n";
    echo "Error Description: " . $helper->getErrorDescription() . "\n";
  } else {
    header('HTTP/1.0 400 Bad Request');
    echo 'Bad request';
  }
  exit;
}

// Logged in
echo '<h3>Access Token</h3>';
var_dump($accessToken->getValue());

// The OAuth 2.0 client handler helps us manage access tokens
$oAuth2Client = $fb->getOAuth2Client();

// Get the access token metadata from /debug_token
$tokenMetadata = $oAuth2Client->debugToken($accessToken);
echo '<h3>Metadata</h3>';
var_dump($tokenMetadata);

// Validation (these will throw FacebookSDKException's when they fail)
$tokenMetadata->validateAppId('1111392495544954'); // Replace {app-id} with your app id
// If you know the user ID this access token belongs to, you can validate it here
//$tokenMetadata->validateUserId('123');
$tokenMetadata->validateExpiration();

if (! $accessToken->isLongLived()) {
  // Exchanges a short-lived access token for a long-lived one
  try {
    $accessToken = $oAuth2Client->getLongLivedAccessToken($accessToken);
  } catch (Facebook\Exceptions\FacebookSDKException $e) {
    echo "<p>Error getting long-lived access token: " . $helper->getMessage() . "</p>\n\n";
    exit;
  }

  echo '<h3>Long-lived</h3>';
  var_dump($accessToken->getValue());
}

$_SESSION['fb_access_token'] = (string) $accessToken;

// User is logged in with a long-lived access token.
// You can redirect them to a members-only page.
//header('Location: https://example.com/members.php');



	// getting basic info about user
	try {
		$profile_request = $fb->get('/me?fields=name,first_name,last_name,birthday,location');
		$profile = $profile_request->getGraphNode()->asArray();
	} catch(Facebook\Exceptions\FacebookResponseException $e) {
		// When Graph returns an error
		echo 'Graph returned an error: ' . $e->getMessage();
		session_destroy();
		// redirecting user back to app login page
		header("Location: ./");
		exit;
	} catch(Facebook\Exceptions\FacebookSDKException $e) {
		// When validation fails or other local issues
		echo 'Facebook SDK returned an error: ' . $e->getMessage();
		exit;
	}
	
	// printing $profile array on the screen which holds the basic info about user
	echo $profile['birthday']->format('d-m-Y');
	echo $profile['location']['name'];


?>
<?php

 /**************************************************************
	*
	*	Updated Hotspot Pages v2.0
	*
	* +     April 09, 2018
	* 	Using facebook php sdk for captive portal & ssl pages
	*
	**************************************************************/

  // Client Configuration
  $portal_name      = "thehappyoak";
  $fb_pageID        = "605038209562783";
  $client_name      = "The Happy Oak";

  // [Don't change these]

  $mac = $_SESSION["mac"];
  $ip = $_SESSION["ip"];
  $username = $_SESSION["username"];
  $linklogin = $_SESSION["linklogin"];
  $linkorig = $_SESSION["linkorig"];
  $error = $_SESSION["error"];
  $chapid = $_SESSION["chapid"];
  $chapchallenge = $_SESSION["chapchallenge"];
  $linkloginonly = $_SESSION["linkloginonly"];
  $linkorigecs = $_SESSION["linkorigesc"];
  $macesc = $_SESSION["macesc"];
  
  $user_device = $_SERVER['HTTP_USER_AGENT'];

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
   "https://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
  <title><?php echo $client_name; ?> Hotspot | iWiFi</title>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
  <meta http-equiv="pragma" content="no-cache" />
  <meta http-equiv="expires" content="-1" />
  <meta http-equiv="cleartype" content="on" />
  <meta http-equiv="x-dns-prefetch-control" content="on">
	<meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="dns-prefetch" href="//facebook.com">
  <link rel="dns-prefetch" href="//static.ak.facebook.com">
  <link rel="dns-prefetch" href="//ak.facebook.com">
  <link rel="dns-prefetch" href="//facebook.com">
  <link rel="dns-prefetch" href="//connect.facebook.net">
  <link rel="dns-prefetch" href="//interactiveonline.co.za">
  <link rel="dns-prefetch" href="//cloudfront.net">
	<link rel="stylesheet" type="text/css" href="css/normalize.css" media="screen" />
	<link rel="stylesheet" type="text/css" href="css/style.css" media="screen" />

	<link rel="shortcut icon" href="img//favicon.ico" />
  <script src="js/libs/jquery.min.js"></script>
  <script src="js/libs/jquery.cookie.js"></script>
  <script src="./md5.js"></script>

  <script type="text/javascript">
    


    jQuery(document).ready(function ($) {

      // Set the options
      $('div.option').fadeIn();
      $('div.logged-in').fadeIn();



			// Count down timer
      document.timer = setInterval(function () {
        var v = parseInt($('span.counter').html());

        if((v - 1) < 0) {

					$('div.option').hide();
					$('div.logged-in').fadeIn();
					$('div.like-box').hide();

          clearInterval(document.timer);
        } else {
          $('span.counter').html(v - 1);
        }
      }, 1000);

			// Handle clicks on the "check-in" button
			$(document).on('click', 'div.logged-in button', function(e){
				e.preventDefault();

				var _this = $(this);

				_this.attr('disabled', true).text('Loading...');

				if(document.logged_in) {

					window.location = _this.data('href');
		
				} else {
					window.location = _this.data('href');
				}
			});


		});
    
    

    
  </script>
</head>
<body>

  <!-- $(if chap-id) -->
	<form name="sendin" action="<?php echo $linkloginonly; ?>" method="post">
	<!-- <form name="sendin" action="https://hotspot.iwifi.co.za" method="post"> -->
		<input type="hidden" name="username" />
		<input type="hidden" name="password" />
		<input type="hidden" name="dst" value="<?php echo $linkorig; ?>" />
		<input type="hidden" name="popup" value="false" />
	</form>
	<script type="text/javascript">
	<!--
    function doLogin() {
      <?php if(strlen($chapid) < 1): ?>
        return true;
      <?php else: ?>
        document.sendin.username.value = document.login.username.value;
        document.sendin.password.value = hexMD5('<?php echo $chapid; ?>' + document.login.password.value + '<?php echo $chapchallenge; ?>');
        document.sendin.submit();
        return false;
      <?php endif; ?>
    }
	//-->
	</script>
  <!-- $(endif) -->

	<!-- Content Area -->

	<div class="content">
		<a href="https://www.interactiveonline.co.za/">
			<img src="img/interactiveonlinelogo.jpg" alt="Interactive Online" height="47" width="213">
		</a>
		<!--
			Client Customization Section
      Logo: Max width = 230px
		-->
		<img src="img/client.png" alt="<?php echo $client_name; ?>" class="location-logo" />

		<!--
			Don't change this unless you are sure
		-->

		<!-- $(if error) -->
			<p class="error"><?php echo $error; ?></p>
		<!-- $(endif) -->

    <div class="option loading"></div>


		<div class="option logged-in">
			<p>
				Thank you for using iWiFi.
				You have 4 hours of free internet access
			</p>
			<!-- $(if trial == 'yes') -->
			<button data-href="<?php echo $linkloginonly; ?>?dst=http://www.thehappyoak.co.za&amp;username=T-<?php echo $macesc; ?>">Click here for free internet access</button>
			<!-- $(endif) -->
		</div>

		
		
	</div>
	
	



	<div class="footer" style="padding-top: 20px;">
		<span style="padding:0px; margin: 0px;" color="white"><font size=2><b>&copy; <?php echo date('Y'); ?> iWiFi - By Interactive Online</b></font>
		<p><a style="color:#ccc; padding:0px; margin: 0px;" href="https://interactiveonline.co.za/privacy-policy/">Terms & Conditions, Privacy Policy</a></p></span>
	</div>

</body>
</html>
